// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/background_sync_service.mojom
//

package org.chromium.mojom.content;

public interface BackgroundSyncService extends org.chromium.mojo.bindings.Interface {

    public interface Proxy extends BackgroundSyncService, org.chromium.mojo.bindings.Interface.Proxy {
    }

    Manager<BackgroundSyncService, BackgroundSyncService.Proxy> MANAGER = BackgroundSyncService_Internal.MANAGER;

    void register(SyncRegistration options, long serviceWorkerRegistrationId, boolean requestedFromServiceWorker, RegisterResponse callback);
    interface RegisterResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<Integer, SyncRegistration> { }

    void getRegistration(int periodicity, String tag, long serviceWorkerRegistrationId, GetRegistrationResponse callback);
    interface GetRegistrationResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<Integer, SyncRegistration> { }

    void getRegistrations(int periodicity, long serviceWorkerRegistrationId, GetRegistrationsResponse callback);
    interface GetRegistrationsResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<Integer, SyncRegistration[]> { }

    void unregister(long handleId, long serviceWorkerRegistrationId, UnregisterResponse callback);
    interface UnregisterResponse extends org.chromium.mojo.bindings.Callbacks.Callback1<Integer> { }

    void getPermissionStatus(int periodicity, long serviceWorkerRegistrationId, GetPermissionStatusResponse callback);
    interface GetPermissionStatusResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<Integer, Integer> { }

    void duplicateRegistrationHandle(long handleId, DuplicateRegistrationHandleResponse callback);
    interface DuplicateRegistrationHandleResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<Integer, SyncRegistration> { }

    void releaseRegistration(long handleId);

    void notifyWhenDone(long handleId, NotifyWhenDoneResponse callback);
    interface NotifyWhenDoneResponse extends org.chromium.mojo.bindings.Callbacks.Callback2<Integer, Integer> { }
}

